/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ptmp.task;

import com.cisco.pt.impl.KeepAliveLTV;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.util.Date;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeepAliveTask
extends TimerTask {
    private static Log logger = LogFactory.getLog(KeepAliveTask.class);
    private PacketTracerSession packetTracerSession;
    private int missedKeepAlives = 0;
    public static int KEEP_ALIVE_INTERVAL = 20000;
    public static int KEEP_ALIVE_TIMEOUT = KEEP_ALIVE_INTERVAL * 3;

    public KeepAliveTask(PacketTracerSession packetTracerSession) {
        this.packetTracerSession = packetTracerSession;
    }

    public void receivedKeepAlive() {
        this.missedKeepAlives = 0;
    }

    public void run() {
        block5: {
            if (this.packetTracerSession.isConnected()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sending keep-alive at: [" + new Date(System.currentTimeMillis()) + "]"));
                }
                try {
                    KeepAliveLTV keepAliveLTV = new KeepAliveLTV();
                    this.packetTracerSession.write(keepAliveLTV);
                    if (this.missedKeepAlives * KEEP_ALIVE_INTERVAL >= KEEP_ALIVE_TIMEOUT) {
                        this.packetTracerSession.connection().disconnect();
                    }
                    ++this.missedKeepAlives;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    this.cancel();
                    if (this.packetTracerSession.timer() == null) break block5;
                    this.packetTracerSession.timer().cancel();
                }
            }
        }
    }
}

